odoo.define('sh_pos_theme_responsive.ProductItem', function (require) {
    'use strict';
    // ============================== //
    //  For product item count badge  //
    // ============================== //
    const Registries = require('point_of_sale.Registries');
    const ProductItem = require('point_of_sale.ProductItem');

    let ShProductItem = (ProductItem) =>
        class extends ProductItem {
            get order() {
                return this.env.pos.get_order();
            }
            get_all_tmpl_qty(){
                let self = this;
                let qty_total=0;
                let variants = this.env.pos.db.has_variant(this.props.product.product_tmpl_id).map((product) => product.id)
                _.each(variants,(id)=> {
                    if(self.order.product_with_qty && self.order.product_with_qty[id]){
                        qty_total += self.order.product_with_qty[id]
                    }
                })
                return qty_total != 0 ? qty_total:false;
            }

        }
    Registries.Component.extend(ProductItem, ShProductItem);
    return ProductItem;
});